/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Pilot.Xps.Domain
{
    static class DictionaryStringFormatterEx
    {
        public static string Format(this string format, IDictionary<string, string> attributes)
        {
            return attributes != null ? Format(format, attributes, CultureInfo.CurrentCulture) : format;
        }

        public static string Format(this string format, IDictionary<string, object> attributes)
        {
            return attributes != null ? Format(format, attributes, CultureInfo.CurrentCulture) : format;
        }

        public static string Format(this string format, IDictionary<string, object> attributes, IFormatProvider defaultFormatProvider)
        {
            if (Regex.IsMatch(format, @"\{(.+?)\}"))
            {
                var result = new StringBuilder(format);
                var matches = Regex.Matches(format, @"\{(.+?)\}");
                var keys = (from Match matche in matches select matche.Groups[1].Value).ToList();

                foreach (var key in keys)
                {
                    var k = key.Split(new[] { ':' }, 2);
                    if (k.Length == 0)
                        continue;

                    attributes = new Dictionary<string, object>(attributes, StringComparer.OrdinalIgnoreCase);
                    var arg = attributes.ContainsKey(k[0]) ? attributes[k[0]] : string.Format("{{{0}}}", key);
                    string pattern = string.Format("{{{0}}}", key);

                    if (k.Length > 1)
                    {
                        if (arg is DateTime)
                        {
                            result.Replace(pattern, ((DateTime)arg).ToString(k[1]));
                        }

                        if (arg is long)
                        {
                            result.Replace(pattern, ((long)arg).ToString(k[1]));
                        }

                        if (arg is double)
                        {
                            result.Replace(pattern, ((double)arg).ToString(k[1]));
                        }

                        if (arg is decimal)
                        {
                            result.Replace(pattern, ((decimal)arg).ToString(k[1]));
                        }

                        if (arg is string)
                        {
                            result.Replace(pattern, arg.ToString());
                        }
                    }
                    else
                    {
                        result.Replace(pattern, arg.ToString());
                    }
                }

                return result.ToString();
            }

            return format;
        }

        public static string Format(this string format, IDictionary<string, string> attributes, IFormatProvider defaultFormatProvider)
        {
            var result = new StringBuilder(format);
            var matches = Regex.Matches(format, @"\{(.+?)\}");
            var keys = (from Match matche in matches select matche.Groups[1].Value).ToList();

            foreach (var key in keys)
            {
                var k = key.Split(':');
                if (k.Length == 0)
                    continue;

                attributes = new Dictionary<string, string>(attributes, StringComparer.OrdinalIgnoreCase);
                var arg = attributes.ContainsKey(k[0]) ? attributes[k[0]] : string.Format("{{{0}}}", key);
                string pattern = string.Format("{{{0}}}", key);
                result.Replace(pattern, arg.ToString());
            }

            return result.ToString();
        }
    }
}
