/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Linq;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.DataModifier;

namespace Pilot.Xps.Domain.Tools
{
    public static class ObjectChangeBuilderExtensions
    {
        public static INFile AddOrReplaceFile(this IObjectChangeBuilder builder, IDocumentInfo document, string filename, IFileStorageProvider fileStorageProvider)
        {
            var toDelete = builder.Change.New.ActualFileSnapshot.Files.FirstOrDefault(x => x.Name == filename);
            if (toDelete != null)
                builder.DeleteFile(toDelete.Id);

            return builder.AddFile(document, fileStorageProvider);
        }

        public static INFile AddOrReplaceFile(this IObjectChangeBuilder builder, IDocumentInfo document, Guid fileId, IFileStorageProvider fileStorageProvider)
        {
            builder.DeleteFile(fileId);
            return builder.AddFile(document, fileStorageProvider);
        }

    }
}
