/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Pilot.Xps.Domain.Labels;
using Pilot.Xps.Domain.Render;

namespace Pilot.Xps.Domain.Tools
{
    class ThreadExtensions
    {
        public static T RunInStaThreadWithResult<T>(Func<T> function)
        {
            T result = default(T);
            Exception exception = null;
            var thread = new Thread(() =>
            {
                try
                {
                    result = function();
                }
                catch (Exception e)
                {
                    exception = e;
                }
            });
            thread.IsBackground = true;
            thread.SetApartmentState(ApartmentState.STA);
            thread.Start();
            thread.Join(300000);

            if (exception != null)
                throw exception;

            return result;
        }

        public static void RunInStaThread<T>(Action action)
        {
            Exception exception = null;
            var thread = new Thread(() =>
            {
                try
                {
                    action();
                }
                catch (Exception e)
                {
                    exception = e;
                }
            });
            thread.IsBackground = true;
            thread.SetApartmentState(ApartmentState.STA);
            thread.Start();
            thread.Join(300000);

            if (exception != null)
                throw exception;
        }
    }
}
