/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows.Markup;

namespace Pilot.Xps.Domain.Tools
{
    static class XamlWriterForGraphicElement
    {
        public static string Save(object graphicElement, string additionalAttributes = "")
        {
            var text = XamlWriter.Save(graphicElement);

            text = text.
                Replace("{}{", "{").
                Replace(
                    "xmlns=\"http://schemas.microsoft.com/winfx/2006/xaml/presentation\"",
                    additionalAttributes
                ).
                Trim();

            return text;
        }
    }
}
