/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Linq;
using System.Xml.Linq;

namespace Pilot.Xps.Domain
{
    static class XpsHelper
    {
        public static string GetConstantTextLabel(string xmlString)
        {
            return GetFilteredTextLabel(xmlString, true);
        }

        public static string GetFloatingTextLabel(string xmlString)
        {
            return GetFilteredTextLabel(xmlString, false);
        }

        public static string GetConstantBarcode(string xmlString)
        {
            return GetFilteredBarcode(xmlString, false);
        }

        public static string GetFloatingBarcode(string xmlString)
        {
            return GetFilteredBarcode(xmlString, true);
        }

        private static string GetFilteredTextLabel(string xmlString, bool removeFloating)
        {
            if (string.IsNullOrEmpty(xmlString))
                return xmlString;

            var xElement = XElement.Parse(xmlString);
            xElement.Elements().Where(Predicate(removeFloating)).Remove();

            return !xElement.Elements().Any() ? null : xElement.ToString();
        }

        private static string GetFilteredBarcode(string xmlString, bool isFloating)
        {
            if (string.IsNullOrEmpty(xmlString))
                return xmlString;

            var xElement = XElement.Parse(xmlString);
            return Predicate(isFloating).Invoke(xElement) ? xElement.ToString() : null;
        }

        private static Func<XElement, bool> Predicate(bool isFloating)
        {
            return e => ((bool?)e.Attribute(BarcodeLabelsConstants.FLOATING_ATTRIBUTE)).GetValueOrDefault() == isFloating;
        }
    }
}
