/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using PilotRocketChatGateway.Authentication;
using PilotRocketChatGateway.PilotServer;
using PilotRocketChatGateway.UserContext;

namespace PilotRocketChatGateway.Controllers
{
    [ApiController]
    [Route("api/v1/[controller]")]
    public class DirectoryController : ControllerBase
    {
        private IContextsBank _contextsBank;
        private readonly IAuthHelper _authHelper;

        public DirectoryController(IContextsBank contextsBank, IAuthHelper authHelper)
        {
            _contextsBank = contextsBank;
            _authHelper = authHelper;
        }

        [Authorize]
        public string Get(string query)
        {
            var requset = JsonConvert.DeserializeObject<DirectoryRequest>(query);
            var context = _contextsBank.GetContext(HttpContext.GetTokenActor(_authHelper));

            var count = int.Parse(HttpContext.Request.Query["count"].ToString());
            var offset = int.Parse(HttpContext.Request.Query["offset"].ToString());

            switch (requset.type)
            {
                case "users":

                    var (users, totalUsers) = context.ChatService.DataLoader.LoadUsers(count, offset, requset.text.ToLower());
                    var result1 = new { success = true, result = users, total = totalUsers, count = count, offset = offset };
                    return JsonConvert.SerializeObject(result1);

                case "channels":

                    var (channels, totalChannels) = context.ChatService.DataLoader.LoadChannels(count, offset, requset.text.ToLower());
                    var result2 = new { success = true, result = channels, total = totalChannels, count = count, offset = offset };
                    return JsonConvert.SerializeObject(result2);

                case "teams":

                    var result3 = new { success = true, total = 0, count = 0, offset = offset, result = new List<string>() };
                    return JsonConvert.SerializeObject(result3);
                default:
                    return string.Empty;
            }
        }
    }
}
