/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;

namespace PilotShare.Client
{
    class LinksLoaderService
    {
        private readonly ISearchService _searchService;
        private readonly IType _externalLinkType;

        public LinksLoaderService(ISearchService searchService, IType externalLinkType)
        {
            _searchService = searchService;
            _externalLinkType = externalLinkType;
        }

        public Task<IEnumerable<Guid>> LoadLinksAsync(IDataObject target)
        {
            var tcs = new TaskCompletionSource<IEnumerable<Guid>>();
            var queryBuilder = _searchService.GetObjectQueryBuilder();
            queryBuilder.Must(ObjectFields.TypeId.Be(_externalLinkType.Id));
            queryBuilder.Must(AttributeFields.String(LinkAttributeNames.TARGET).Be(target.Id.ToString()));
            queryBuilder.Must(ObjectFields.ObjectState.Be(ObjectState.Alive));

            _searchService.Search(queryBuilder).Subscribe(result =>
            {
                if (tcs.Task.IsCompleted)
                    return;

                tcs.SetResult(result.Result);
            });

            return tcs.Task;
        }
    }
}
