/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;

namespace PilotShare.Client.Utils
{
    class ObjectLoader: IDisposable
    {
        private readonly IObjectsRepository _repository;
        private readonly List<IDisposable> _disposables = new List<IDisposable>();

        public ObjectLoader(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public Task<IEnumerable<IDataObject>> LoadObjectsAsync(Guid[] ids)
        {
            var tcs = new TaskCompletionSource<IEnumerable<IDataObject>>();
            var objectList = new List<IDataObject>();
            var objectSubscription = _repository.SubscribeObjects(ids).Subscribe(o =>
            {
                objectList.Add(o);

                if (objectList.Count == ids.Length)
                    tcs.SetResult(objectList);
                
            });

            _disposables.Add(objectSubscription);
            return tcs.Task;
        }

        public void Dispose()
        {
            foreach (var disposable in _disposables)
            {
                disposable.Dispose();
            }
        }
    }
}
