/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PilotShare.Client.Utils
{
    public static class PathExtensions
    {
        public static string RemoveInvalidPathCharacters(string str)
        {
            var sb = new StringBuilder();
            foreach (char c in str)
            {
                if (!Path.GetInvalidFileNameChars().Contains(c))
                {
                    sb.Append(c);
                }
            }

            var path = sb.ToString();
            return path.TrimEnd('.');
        }
    }
}
