/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.IO;
using System.Linq;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.SDK.Toolbar;
using PilotShare.Client.Properties;

namespace PilotShare.Client.View
{
    [Export(typeof(IMenu<ObjectsViewContext>)), Export(typeof(IToolbar<ObjectsViewContext>))]
    public class DocumentsExplorerToolbarAndContextMenuExtension : ToolbarItemSubmenuHandler, IMenu<ObjectsViewContext>, IToolbar<ObjectsViewContext>
    {
        private static string CreateLinkCaption => "miCreateCaption";
        private static string SharedSettingsCaption => "miShowSharingSettings";
        

        private readonly IPilotShareDialogService _pilotShareDialogService;

        [ImportingConstructor]
        public DocumentsExplorerToolbarAndContextMenuExtension(IPilotShareDialogService pilotShareDialogService)
        {
            _pilotShareDialogService = pilotShareDialogService;
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            if (context.SelectedObjects.Count() == 1)
            {
                var selected = context.SelectedObjects.First();

                if(selected.Type.Kind != TypeKind.User)
                    return;

                var index = builder.ItemNames.Contains(SharedSettingsCaption) ?
                    builder.ItemNames.ToList().IndexOf(SharedSettingsCaption) : builder.ItemNames.Count() - 1;

                builder.AddItem(CreateLinkCaption, ++index)
                    .WithHeader(Resources.ShareLink)
                    .WithIcon(ResourceLoader.Load("share.svg"));
            }
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            Click(name, context);
        }

        public void Build(IToolbarBuilder builder, ObjectsViewContext context)
        {
            if (context.SelectedObjects.Count() == 1)
            {
                var selected = context.SelectedObjects.First();

                if (selected.Type.Kind != TypeKind.User)
                    return;

                var index = builder.ItemNames.Count() - 1;

                builder.AddSeparator(++index);
                builder.AddButtonItem(CreateLinkCaption, ++index)
                    .WithHeader(Resources.ShareLink)
                    .WithIcon(ResourceLoader.Load("share.svg"));
            }
        }

        public override void OnSubmenuRequested(IToolbarBuilder builder)
        {
        }

        public void OnToolbarItemClick(string name, ObjectsViewContext context)
        {
            Click(name, context);
        }

        public void Click(string name, ObjectsViewContext context)
        {
            if (context.SelectedObjects.Count() == 1 && name == CreateLinkCaption)
            {
                var selected = context.SelectedObjects.First();
                _pilotShareDialogService.ShowExternalLinkManager(selected);
            }
        }
    }
}
