/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Xml.Serialization;

namespace PilotShare.Core
{
    public static class StructureSerializer
    {
        public static string Serialize(Item root)
        {
            var xmlSerializer = new XmlSerializer(typeof(Item));

            using (StringWriter textWriter = new StringWriter())
            {
                xmlSerializer.Serialize(textWriter, root);
                return textWriter.ToString();
            }
        }

        public static Item Deserialize(string xml)
        {
            try
            {
                var xmlSerializer = new XmlSerializer(typeof(Item));

                using (var textReader = new StringReader(xml))
                {
                    return (Item)xmlSerializer.Deserialize(textReader);
                }
            }
            catch
            {
                //report
            }
            return null;
        }

        //public static byte[] Serialize(Item obj)
        //{
        //    using (var ms = new MemoryStream())
        //    {
        //        Serializer.Serialize(ms, obj);
        //        return ms.ToArray();
        //    }
        //}

        //public static T Deserialize<T>(byte[] data)
        //{
        //    using (var fs = new MemoryStream(data))
        //    {
        //        return Serializer.Deserialize<T>(fs);
        //    }
        //}
    }
}
