/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.StaticFiles;
using PilotShare.Server.Models;

namespace PilotShare.Server.Controllers
{
    public class FilesController : Controller
    {
        private readonly ILinkStateProvider _linkStateProvider;
        private readonly IFileLoaderService _fileLoaderService;

        public FilesController(ILinkStateProvider linkStateProvider, IFileLoaderService fileLoaderService)
        {
            _linkStateProvider = linkStateProvider;
            _fileLoaderService = fileLoaderService;
        }

        [HttpPost]
        [Route("/files/download/")]
        public async Task<IActionResult> Download([FromBody]FileDownloadData data)
        {
            Guid guid = new Guid(data.Id);
            var bytes = await _fileLoaderService.LoadFilesAsync(guid, data.Password);
            
            var fileName = $"{guid}.zip";
            new FileExtensionContentTypeProvider().TryGetContentType(fileName, out var type);
            var contentType = type ?? "application/octet-stream";
            return File(bytes, contentType);
        }

        [Route("/files/{id}")]
        public async Task<IActionResult> Index(string id)
        {
            var linkId = Guid.Parse(id);
            try
            {
                var state = await _linkStateProvider.GetStateLinkAsync(linkId);
                return View(new FileModel { State = state });
            }
            catch (PilotShareLinkException e)
            {
                return View(new FileModel { Exception = e});
            }
        }
    }

    public class FileDownloadData
    {
        public string Id { get; set; }
        public string Password { get; set; }
    }

    public class FileModel
    {
        public State State { get; set; }
        public Exception Exception { get; set; }
    }
}
