/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ServiceModel.Security;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.Transport;
using log4net;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using PilotShare.Server.Models;

namespace PilotShare.Server.Middleware
{
    public sealed class ExceptionHandlerMiddleware
    {
        private readonly RequestDelegate _next;
        //private readonly ILogger<ExceptionHandlerMiddleware> _logger;
        private readonly ILog _logger = LogManager.GetLogger(typeof(ExceptionHandlerMiddleware));
        public ExceptionHandlerMiddleware(RequestDelegate next)
        {
            _next = next;
        }
        public async Task Invoke(HttpContext context)
        {
            try
            {
                await _next(context);
            }
            catch (TransportException e)
            {
                _logger.Info(e.Message);
                context.Response.StatusCode = 503; //Service Unavailable
                await context.Response.WriteAsync("Pilot-Server is unavailable");
            }
            catch (SecurityAccessDeniedException e)
            {
                context.Response.StatusCode = 401;
                await context.Response.WriteAsync(e.Message);
            }
            catch (Exception e)
            {
                _logger.Error(e);
                throw;
                //context.Response.StatusCode = 500; //Internal error
                //await context.Response.WriteAsync(e.Message);
            }
        }
    }

    public static class ExceptionHandlerMiddlewareExtensions
    {
        public static IApplicationBuilder UseExceptionHandlerMiddleware(this IApplicationBuilder builder)
        {
            return builder.UseMiddleware<ExceptionHandlerMiddleware>();
        }
    }

    public class ErrorDto
    {
        public int Code { get; set; }
        public string Message { get; set; }
        public override string ToString()
        {
            return JsonConvert.SerializeObject(this);
        }
    }
}
