/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Ascon.Pilot.Server.Api;
using Ascon.Pilot.Server.Api.Contracts;

namespace PilotShare.Server.Models
{
    interface IRemoteServices
    {
        IServerApi GetServerApi();
        IFileArchiveApi GetFileArchiveApi();
    }

    class RemoteServices : IRemoteServices
    {
        private readonly IServerApi _serverApi;
        private readonly IFileArchiveApi _fileArchiveApi;

        public RemoteServices(ConnectionCredentials credentials, int licenseCode)
        {
            var client = new HttpPilotClient(credentials.GetConnectionString());
            _serverApi = new ServerApiWrapper(credentials, client, licenseCode);
            _fileArchiveApi = client.GetFileArchiveApi();
        }
        public IServerApi GetServerApi()
        {
            return _serverApi;
        }

        public IFileArchiveApi GetFileArchiveApi()
        {
            return _fileArchiveApi;
        }
    }
}
