﻿// Please see documentation at https://docs.microsoft.com/aspnet/core/client-side/bundling-and-minification
// for details on configuring this project to bundle and minify static web assets.

// Write your JavaScript code.

function download(id) {
    let password = '';
    if ($('#inputPassword')) {
        password = $('#inputPassword').val();
    }

    $('#error-message').text('');
    $('#inputPassword').removeClass("is-invalid");

    fetch('/files/download/', {
        method: 'POST', // *GET, POST, PUT, DELETE, etc.
        mode: 'cors', // no-cors, *cors, same-origin
        cache: 'no-cache', // *default, no-cache, reload, force-cache, only-if-cached
        credentials: 'same-origin', // include, *same-origin, omit
        headers: {
          'Content-Type': 'application/json'
          // 'Content-Type': 'application/x-www-form-urlencoded',
        },
        redirect: 'follow', // manual, *follow, error
        referrerPolicy: 'no-referrer', // no-referrer, *client
        body: JSON.stringify({ id : id, password : password }) // body data type must match "Content-Type" header
      })
        .then((response) => {
            if (response.status !== 200) {
                return response.text().then(text => { throw Error(text); });
            } else {
                return response.blob();
            }
        })
        .then((blob) => {
            downloadData('archive.zip', blob);
        })
        .catch(error => {
            $('#error-message').text(error.message);
            $('#inputPassword').addClass("is-invalid");

            console.error(error.message);
        });
}

function onEnter(id, event) {
    if (event.charCode === 13) {
        download(id);
    }
}

// Solution for big files (source: https://stackoverflow.com/a/25975345/831138)
function downloadData(filenameForDownload, data) {
    var textUrl = URL.createObjectURL(data);
    var element = document.createElement('a');
    element.setAttribute('href', textUrl);
    element.setAttribute('download', filenameForDownload);
    element.style.display = 'none';
    document.body.appendChild(element);
    element.click();
    document.body.removeChild(element);
}
