using UrlsHandlerSample.Services;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorPages();
builder.Services.AddSingleton<IPilotRegisterService, PilotRegisterService>();
builder.Services.AddSingleton<PilotObjectInfoService>();
builder.Services.AddSingleton<IPilotObjectInfoService>((p) => p.GetRequiredService<PilotObjectInfoService>());
builder.Services.AddSingleton<IPilotServiceConnector>((p) => p.GetRequiredService<PilotObjectInfoService>());
builder.Services.AddHttpContextAccessor();
builder.Services.AddDistributedMemoryCache();
builder.Services.AddSession(options =>
{
    options.IdleTimeout = TimeSpan.FromMinutes(10);
    options.Cookie.HttpOnly = true;
    options.Cookie.IsEssential = true;
});

var app = builder.Build();
var serviceProvider = app.Services;

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");
}

app.Lifetime.ApplicationStopping.Register(() =>
{
    try
    {
        var registryService = serviceProvider.GetRequiredService<IPilotRegisterService>();
        registryService.UnregisterAll();
    }
    catch (Exception)
    {
        //    
    }
});

app.UseStaticFiles();
app.UseRouting();
app.UseSession();
app.UseAuthorization();
app.MapRazorPages();
app.Run();
