﻿namespace UrlsHandlerSample.Services
{
    public interface IServerAddressProvider
    {
        IEnumerable<string> Addresses { get; }
        void SetAddresses(IEnumerable<string> addresses);
    }

    internal class ServerAddressProvider : IServerAddressProvider
    {
        private IEnumerable<string> _addresses = Enumerable.Empty<string>();

        public IEnumerable<string> Addresses => _addresses;

        public void SetAddresses(IEnumerable<string> addresses)
        {
            _addresses = addresses;
        }
    }
}
