const fs = require('fs-extra');

// Function to copy files from one directory to another
async function copyFiles(sourceDir, destDir) {
  try {
    // Ensure the destination directory exists
    await fs.ensureDir(destDir);

    // Read the source directory
    const files = await fs.readdir(sourceDir);

    // Iterate over each file in the source directory
    for (const file of files) {
      const srcFile = `${sourceDir}/${file}`;
      const destFile = `${destDir}/${file}`;

      // Check if the item is a file or directory
      const stats = await fs.stat(srcFile);
      if (stats.isFile()) {
        // Copy the file
        await fs.copy(srcFile, destFile);
        console.log(`Copied ${file} from ${sourceDir} to ${destDir}`);
      } else if (stats.isDirectory()) {
        // Recursively copy directories
        await copyFiles(srcFile, `${destDir}/${file}`);
      }
    }
  } catch (error) {
    console.error('Error copying files:', error);
  }
}

// Example usage
if (process.argv.length <= 1) {
  console.log('Please provide extension name.');
  return;
}

const extensionName = process.argv[2];
const sourceDir = './dist';
const destDir = `../../../dist/${extensionName}/frontend`;
console.error(extensionName)
console.error(destDir)
copyFiles(sourceDir, destDir)
    .then(() => console.log(`All files of ${extensionName} copied successfully`))
    .catch((err) => console.error(err));