/*
Copyright © 2024 ASCON-Design Systems LLC. All rights reserved.
This sample is licensed under the MIT License.
*/
export function convertToString(file: ArrayBuffer): string {
  let str = '';
  const bytes = new Uint8Array(file);

  for (let i = 0; i < bytes.byteLength; i++) 
    str += String.fromCharCode(bytes[i]);

  return str;
}

export function convertToArrayBuffer(base64: string): ArrayBuffer {
  const bytes = new Uint8Array(base64.length);
  for (let i = 0; i < base64.length; i++) {
    bytes[i] = base64.charCodeAt(i);
  }
  return bytes.buffer;
}

export function getCNPart(str: string): string {
 const cnRegex: RegExp = new RegExp("(?:CN|cn)=([^\n,]+)");

 if (!str)
    return '';

  const match = cnRegex.exec(str);
  if (!match || match.length < 2)
    return '';

  return match[1];
}
