import { Component, Inject, OnInit } from '@angular/core';
import { Breakpoints } from "@angular/cdk/layout";
import { IDataObject, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";
import { ASSETS_URL } from "../../extension/views";
import { ObjectInfoDisplayComponent } from "../object-info-display/object-info-display.component";
import { ObjectInfoComponent } from "../object-info/object-info.component";

@Component({
  selector: 'app-object-info-container',
  standalone: true,
  imports: [
    ObjectInfoComponent
  ],
  templateUrl: './object-info-container.component.html',
  styleUrl: './object-info-container.component.scss'
})
export class ObjectInfoContainerComponent implements OnInit {
  private _selectedObject!: IDataObject;

  public get selectedObject(): IDataObject {
    return this._selectedObject;
  }

  constructor(
    @Inject('ObjectsViewContext') protected objectsViewContext: ObjectsViewContext) {}

  ngOnInit(): void {
    this._selectedObject = this.objectsViewContext.selectedObjects[0];
  }
}
