import { Component, Inject, Input } from '@angular/core';
import { MatListModule } from "@angular/material/list";
import { IChild, IDialogService, IObjectsRepository } from "@pilotdev/pilot-web-sdk";
import { NgForOf } from "@angular/common";
import { MatButton } from "@angular/material/button";
import { SelectedObjectService } from "../../../services/selected-object.service";

@Component({
  selector: 'app-children',
  standalone: true,
  imports: [MatListModule, NgForOf, MatButton],
  templateUrl: './children.component.html',
  styleUrl: './children.component.scss'
})
export class ChildrenComponent {
  @Input() children: IChild[] = [];

  constructor(
    @Inject("IObjectsRepository") private _objectsRepository: IObjectsRepository,
    private _selectedObjectService: SelectedObjectService,
  ) {}

  public showInfo(child: IChild): void {
    this._objectsRepository.getObjects([child.objectId])
      .subscribe(dataObject => {
        this._selectedObjectService.setSelectedObject(dataObject[0]);
      });
  }
}
