import {
  AccessLevel, DialogContext,
  IDataObject, IDialogService,
  IInitializable, IMenu, IMenuBuilder,
  InjectionSource, IObjectsRepository, ObjectsViewContext
} from "@pilotdev/pilot-web-sdk";
import { ObjectInfoViewId } from "./views/consts";

export class ObjectInfoExtension implements IMenu<ObjectsViewContext>, IInitializable {
  private readonly OBJECT_INFO_ITEM_NAME = "ObjectInfoItemName";

  private _objectsRepository!: IObjectsRepository;
  private _dialogService!: IDialogService;

  initialize(injectionSource: InjectionSource): void {
    this._objectsRepository = injectionSource.objectsRepository;
    this._dialogService = injectionSource.dialogService;
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext) {
    if (context.contextObject == null) {
      return;
    }

    if (!this.hasViewAccess(context.contextObject)) {
      return;
    }

    if (context.selectedObjects.length != 1) {
      return;
    }

    builder.addItem(this.OBJECT_INFO_ITEM_NAME, 0).withHeader("Информация об объекте");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext) {
    this._dialogService.openDialogWithExit(ObjectInfoViewId, new DialogContext(context), "Pilot object info");
  }

  private hasViewAccess(obj: IDataObject): boolean {
    return (obj.accessLevel & AccessLevel.View) === AccessLevel.View;
  }
}
