import { Inject, Injectable } from "@angular/core";
import { BehaviorSubject, Observable } from "rxjs";
import { IDataObject, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

@Injectable({
  providedIn: 'root'
})
export class SelectedObjectService {
  private selectedObjectSubject: BehaviorSubject<IDataObject | null>;

  constructor(
    @Inject('ObjectsViewContext') protected objectsViewContext: ObjectsViewContext
  ) {
    this.selectedObjectSubject = new BehaviorSubject<IDataObject | null>(this.objectsViewContext.selectedObjects[0] || null);
  }

  getSelectedObject(): Observable<IDataObject | null> {
    return this.selectedObjectSubject.asObservable();
  }

  setSelectedObject(value: IDataObject): void {
    this.selectedObjectSubject.next(value);
  }
}
