import { ObjectsViewContext, IDataObject, AccessLevel, ICommandBuilder, IProgressService, ProgressBarMode } from "@pilotdev/pilot-web-sdk";  
import { ICommand } from "../projectCloneWizard";

export class PasteStructureCommand implements ICommand {

  private _structureRoot!: IDataObject;

  constructor(private _commandBuilderProvider: ICommandBuilder,
              private _progressService: IProgressService) {}

  public get structureRoot(): IDataObject {
    return this._structureRoot;
  }
  public set structureRoot(value: IDataObject) {
    this._structureRoot = value;
  }


  canCreate(context: ObjectsViewContext): boolean {
    if (context.contextObject != null)
      return false;

    if (this._structureRoot == undefined)
      return false;

    return true;
  }

  isEnabled(context: ObjectsViewContext): boolean {

    if (!this.hasCreateAccess(context.selectedObjects[0], this._structureRoot.type.id))
      return false; 

    return true;
  }

  invoke(destinaion: string): void {
    this._progressService.open(ProgressBarMode.Indeterminate);
    this._commandBuilderProvider.command('copyStructure')
                                .arg('structureRoot', this._structureRoot.id)
                                .arg('destinaion', destinaion)
                                .invoke()
                                .subscribe(() => this._progressService.close());
  };

  private hasCreateAccess(obj: IDataObject, rootTypeId: number): boolean {
    if (!obj.type.children.includes(rootTypeId))
      return false;

    return (obj.accessLevel & AccessLevel.Create) == AccessLevel.Create;
  }
}

