
export class IconResources {
  static copyStructureHere: string = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHZlcnNpb249IjEuMSIgIHdpZHRoPSI0OCIgaGVpZ2h0PSI0OCIgdmlld0JveD0iMCAwIDI0IDI0Ij4NCiAgPHBhdGggZmlsbD0iIzYyNjI2MiIgZD0iTTExLDE3SDRBMiwyIDAgMCwxIDIsMTVWM0EyLDIgMCAwLDEgNCwxSDE2VjNINFYxNUgxMVYxM0wxNSwxNkwxMSwxOVYxN00xOSwyMVY3SDhWMTNINlY3QTIsMiAwIDAsMSA4LDVIMTlBMiwyIDAgMCwxIDIxLDdWMjFBMiwyIDAgMCwxIDE5LDIzSDhBMiwyIDAgMCwxIDYsMjFWMTlIOFYyMUgxOVoiIC8+DQo8L3N2Zz4=";
  static copyStructure: string = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4NCjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHZlcnNpb249IjEuMSIgd2lkdGg9IjI0IiBoZWlnaHQ9IjI0IiB2aWV3Qm94PSIwIDAgMjQgMjQiPg0KICA8cGF0aCBmaWxsPSIjNjI2MjYyIiBkPSJNMTksMjFIOFY3SDE5TTE5LDVIOEEyLDIgMCAwLDAgNiw3VjIxQTIsMiAwIDAsMCA4LDIzSDE5QTIsMiAwIDAsMCAyMSwyMVY3QTIsMiAwIDAsMCAxOSw1TTE2LDFINEEyLDIgMCAwLDAgMiwzVjE3SDRWM0gxNlYxWiIgLz4NCjwvc3ZnPg==";
  static pasteStructure: string = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4NCjwhRE9DVFlQRSBzdmcgUFVCTElDICItLy9XM0MvL0RURCBTVkcgMS4xLy9FTiIgImh0dHA6Ly93d3cudzMub3JnL0dyYXBoaWNzL1NWRy8xLjEvRFREL3N2ZzExLmR0ZCI+DQo8c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHZlcnNpb249IjEuMSIgd2lkdGg9IjI0IiBoZWlnaHQ9IjI0IiB2aWV3Qm94PSIwIDAgMjQgMjQiPg0KICA8cGF0aCBmaWxsPSIjNjI2MjYyIiBkPSJNMTksMjBINVY0SDdWN0gxN1Y0SDE5TTEyLDJBMSwxIDAgMCwxIDEzLDNBMSwxIDAgMCwxIDEyLDRBMSwxIDAgMCwxIDExLDNBMSwxIDAgMCwxIDEyLDJNMTksMkgxNC44MkMxNC40LDAuODQgMTMuMywwIDEyLDBDMTAuNywwIDkuNiwwLjg0IDkuMTgsMkg1QTIsMiAwIDAsMCAzLDRWMjBBMiwyIDAgMCwwIDUsMjJIMTlBMiwyIDAgMCwwIDIxLDIwVjRBMiwyIDAgMCwwIDE5LDJaIiAvPg0KPC9zdmc+";
}

export class Icon {
  constructor(public name: string, public base64: string){}
}

export class Icons {

  private static _instanse: Icons;
  private _map: Map<string, Icon> =  new Map<string, Icon>();

  public static instance(): Icons {
    if (!Icons._instanse)
      Icons._instanse = new Icons();
    return Icons._instanse;
  }

  private constructor() {

    const iconSource = (str: string) => {
      return IconResources[str as keyof IconResources];
    };

    for (const name in IconResources) {
      if (IconResources.hasOwnProperty(name)) { 
        this._map.set(name, new Icon(name, iconSource(name)));
      }
    }

  }

  getInstance(name: string): Icon {
    return this._map.get(name)!;
  }

}
