/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/

import { IMenu, IMenuBuilder, ObjectsViewContext, ICommandBuilderProvider, IProgressService, IThemeService } from "@pilotdev/pilot-web-sdk";  
import { COMMAND_COPY_STRUCTURE_HERE_INDEX, COMMAND_COPY_STRUCTURE_HERE_NAME, COMMAND_COPY_STRUCTURE_HERE_TITLE, COMMAND_COPY_STRUCTURE_INDEX, COMMAND_COPY_STRUCTURE_NAME, COMMAND_COPY_STRUCTURE_TITLE, COMMAND_PASTE_STRUCTURE_INDEX, COMMAND_PASTE_STRUCTURE_NAME, COMMAND_PASTE_STRUCTURE_TITLE } from "./constants";
import { ProjectCloneWizard } from "./projectCloneWizard";
import { Icon, Icons } from "./icons";
import { Inject, Injectable } from "@angular/core";

@Injectable({providedIn: "root"})
export class Menu implements IMenu<ObjectsViewContext> {

  private readonly _wizard: ProjectCloneWizard; 
  private readonly _icons: Icons;

  constructor(@Inject(`ICommandBuilderProvider`) commandBuilderProvider: ICommandBuilderProvider,
              @Inject(`IProgressService`) progressService: IProgressService) {

    this._wizard = ProjectCloneWizard.instance;
    this._wizard.init(commandBuilderProvider.newCommandBuilder(), progressService);
    this._icons = Icons.instance();
  }


  build(builder: IMenuBuilder, context: ObjectsViewContext): void {

    if (this._wizard.needToAddSeparator(context))
      builder.addSeparator(COMMAND_COPY_STRUCTURE_HERE_INDEX - 1)

    if (this._wizard.createStructureHere.canCreate(context))
      builder.addItem(COMMAND_COPY_STRUCTURE_HERE_NAME, COMMAND_COPY_STRUCTURE_HERE_INDEX)
             .withHeader(COMMAND_COPY_STRUCTURE_HERE_TITLE)
             .withIcon(this._icons.getInstance('copyStructureHere').name, this._icons.getInstance('copyStructureHere').base64)
             .withIsEnabled(this._wizard.createStructureHere.isEnabled(context));

    if (this._wizard.copyStructure.canCreate(context))
      builder.addItem(COMMAND_COPY_STRUCTURE_NAME, COMMAND_COPY_STRUCTURE_INDEX)
             .withHeader(COMMAND_COPY_STRUCTURE_TITLE)
             .withIsEnabled(this._wizard.copyStructure.isEnabled(context))
             .withIcon(this._icons.getInstance('copyStructure').name, this._icons.getInstance('copyStructure').base64);

             
    if (this._wizard.needToAddSeparator(context))
      builder.addSeparator(COMMAND_COPY_STRUCTURE_INDEX + 1);

    if (this._wizard.pasteStructure.canCreate(context))
      builder.addItem(COMMAND_PASTE_STRUCTURE_NAME, COMMAND_PASTE_STRUCTURE_INDEX)
             .withHeader(COMMAND_PASTE_STRUCTURE_TITLE)
             .withIcon(this._icons.getInstance('pasteStructure').name, this._icons.getInstance('pasteStructure').base64)
             .withIsEnabled(this._wizard.pasteStructure.isEnabled(context));
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    this._wizard.invokeCommand(name, context);
  }
}