const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
output: {
  publicPath: 'auto',
  uniqueName: 'angular_sample',
  scriptType: 'text/javascript',
},
optimization: {
  // fix a temporary bug
  runtimeChunk: false
},
plugins: [
  new ModuleFederationPlugin({
    name: 'angular_sample',
    library: { type: 'var', name: 'angular_sample' },
    filename: '[name].js',
    exposes: [
      {
        'ITabs<ObjectsViewContext>':
          './src/app/extension/angular-sample.ts',
      },
      {
        'IOpenspaceView<ObjectsViewContext>':
          './src/app/extension/angular-sample.ts',
      },
    ],
    shared: {
      '@angular/core': {
        singleton: true,
      },
      '@angular/common': {
        singleton: true,
      },
      '@angular/material': {
        singleton: true,
      },
      '@angular/forms': {
        singleton: true,
      },
      '@angular/router': {
        singleton: true,
      },
      'rxjs': {
        singleton: true,
      },
      '@pilotdev/pilot-web-sdk': {
        singleton: true,
      }
    }
  })
]
};