import { ICertificate, ISignatureVerificationResult, CadesType, IImportedSignatureVerificationResult } from "@pilotdev/pilot-web-sdk";

export interface IAdapter {
  canProcessSignature(signatureFile: ArrayBuffer): boolean;
  sign(file: ArrayBuffer, certificate: ICertificate): string;
  verify(file: ArrayBuffer, sign: ArrayBuffer, signatureType: CadesType): ISignatureVerificationResult;
  verifyImportedSignature(file: ArrayBuffer, sign: ArrayBuffer): IImportedSignatureVerificationResult;
  getCertificates(): ICertificate[];
}