import { AccessLevel, AttributeType, Guid, IDataObject, IInitializable, IMenu, IMenuBuilder, IModifierProvider, InjectionSource, IObjectsRepository, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class ModifyObjectsSample extends IMenu<ObjectsViewContext> implements IInitializable {
  private readonly CREATE_COPY_ITEM_NAME = "CreateCopyItemName";

  private _objectsRepository!: IObjectsRepository;
  private _modifierProvider!: IModifierProvider;

  initialize(injectionSource: InjectionSource): void {
    this._objectsRepository = injectionSource.objectsRepository;
    this._modifierProvider = injectionSource.modifierProvider;
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    
    if (context.contextObject == null)
      return;

    if (!this.hasCreateAccess(context.contextObject))
      return;

    if (context.selectedObjects.length != 1)
      return;
    
    const indexItemName = "accessRights";
    const insertIndex = builder.itemNames.indexOf(indexItemName) + 1;
    builder.addItem(this.CREATE_COPY_ITEM_NAME, insertIndex).withHeader("Копировать");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {

    const selectedObject = context.selectedObjects[0];
    const modifier = this._modifierProvider.newModifier();
    const builder = modifier.create(Guid.newGuid(), selectedObject.parentId, selectedObject.type.id);
    
    for (const name in selectedObject.attributes) {

      const attr = selectedObject.type.attributes.find(x => x.name == name); 
      const val = selectedObject.attributes[name];
      switch(attr!.type) {
        case AttributeType.UserState: { 
          builder.setAttribute(name, val, AttributeType.UserState);
          break; 
        }
        case AttributeType.DateTime: { 
          builder.setAttribute(name, val, AttributeType.DateTime);
          break; 
        } 
        case AttributeType.Decimal: { 
          builder.setAttribute(name, val, AttributeType.Decimal);
          break; 
        }
        case AttributeType.Double: { 
          builder.setAttribute(name, val, AttributeType.Double);
          break; 
        }  
        case AttributeType.Integer: { 
          builder.setAttribute(name, val, AttributeType.Integer);
          break; 
        }
        case AttributeType.String: { 
          builder.setAttribute(name, val, AttributeType.String);
          break; 
        }  
        default: { 
          throw new Error("not Implemented");
       }
      }
    }

    modifier.apply().subscribe();
  }

  private hasCreateAccess(obj: IDataObject): boolean {
    const currentPerson = this._objectsRepository.getCurrentPerson();
    return (obj.accessLevel & AccessLevel.Create) == AccessLevel.Create;
  }
}