﻿using Ascon.Pilot.ClientCore.Search;
using Pilot.WebServer.SDK.Data;
using Pilot.WebServer.SDK.Search;

namespace SearchSample;

public class PeopleEventsObserver : IObserver<IPerson>
{
    private readonly ISearchService _searchService;

    public PeopleEventsObserver(ISearchService searchService)
    {
        _searchService = searchService;
    }

    public void OnNext(IPerson person)
    {
        if (person.IsDeleted)
        {
            var queryBuilder = _searchService.GetObjectQueryBuilder();
            queryBuilder.Must(ObjectFields.CreatorId.Be(person.Id));

            var resultObserver = new SearchResultObserver(person);
            var search = _searchService.Search(queryBuilder);
            search.Subscribe(resultObserver);
        }
    }

    public void OnCompleted() 
    { 
    }

    public void OnError(Exception error) 
    { 
    }
}
