import { ICommandBuilderProvider } from "@pilotdev/pilot-web-sdk";
import { SETTING_NAME } from "../../const";

export class GetSettingValueCommand {

  public static readonly MENU_NAME = "GetOptionValue";

  private static readonly BACKEND_COMMAND_NAME = "GetOptionValue";

  constructor(private _commandBuilderProvider: ICommandBuilderProvider) {}
  
  public invoke(): void {

    const builder = this._commandBuilderProvider.newCommandBuilder();
    builder.command(GetSettingValueCommand.BACKEND_COMMAND_NAME)
            .arg("key", SETTING_NAME)
            .invoke<string>()
            .subscribe(x => {
              alert(`responce: ${x}`);
            });
  }
} 