import { Guid, ICommandBuilderProvider } from "@pilotdev/pilot-web-sdk";
import { SETTING_NAME } from "../../const";

export class SetOptionValueCommand {

  public static readonly MENU_NAME = "SetOptionValue";
  private static readonly BACKEND_COMMAND_NAME = "SetOptionValue";

  constructor(private _commandBuilderProvider: ICommandBuilderProvider) {}

  public invoke(): void {

    const builder = this._commandBuilderProvider.newCommandBuilder();
    builder.command(SetOptionValueCommand.BACKEND_COMMAND_NAME)
           .arg("key", SETTING_NAME)
           .arg("val", "Some-Unique-Value")
           .invoke<string>().subscribe(x => {
             alert(`responce: ${x}`);
           });
  }
}