const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
  output: {
    publicPath: 'auto',
    uniqueName: 'angular_sample',
    scriptType: 'text/javascript',
  },
  optimization: {
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'settings_support_sample',
      library: { type: 'var', name: 'settings_support_sample' },
      filename: '[name].js',
      exposes: [
        { 'IMenu<ObjectsViewContext>': './src/app/extension/settings-support-sample.ts' },
        { 'ISettingsFeature': './src/app/extension/settings-support-sample.ts' },
        { 'IOpenspaceView<SettingsFeatureContext>': './src/app/extension/settings-support-sample.ts'}
      ],
      shared: {
        '@angular/core': {
          singleton: true,
        },
        '@angular/common': {
          singleton: true,
        },
        '@angular/material': {
          singleton: true,
        },
        '@angular/forms': {
          singleton: true,
        },
        '@angular/router': {
          singleton: true,
        },
        'rxjs': {
          singleton: true,
        },
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    })
  ]
};