import { LocalStorageKeyGenerator } from "./localstorage-key.generator";

export class LocalStorageService {

  constructor(private keyGenerator: LocalStorageKeyGenerator) {
  }

  getStoragePrefix(): string {
    return this.keyGenerator.prefix;
  } 

  getItem(key: string): string | null {
    const token = this.keyGenerator.generateLocalStorageKeyToken(key);
    return localStorage.getItem(token);
  } 

  setItem(key: string, value: any): void {
    const token = this.keyGenerator.generateLocalStorageKeyToken(key);
    localStorage.setItem(token, value);
  }

  removeItem(key: string): void {
    const token = this.keyGenerator.generateLocalStorageKeyToken(key);
    localStorage.removeItem(token);
  }
}
