import { IObjectsRepository } from "@pilotdev/pilot-web-sdk";

export interface LocalstorageKeyToken {
  personId: number;
  key: string;
}
export class LocalStorageKeyGenerator {
  constructor(
    private readonly _repository: IObjectsRepository,
    private readonly _extName: string
  ) {
  }

  get prefix(): string {
    const person = this._repository.getCurrentPerson();
    return [this._extName, person?.id].join('/');
  }

  generateLocalStorageKeyToken(key: string): string {
    return [this.prefix, key].join('/');
  }

  parseLocalStorageKeyToken(token: string): LocalstorageKeyToken | string {
    if (token.includes('/')) {
      const [ _, personId, key] = token.trim().split('/');

      if (Number.isNaN(+personId)) {
        throw new Error('Person id is not a number.');
      }

      return {
        personId: Number.parseInt(personId),
        key: key,
      };
    }
    return token;
  }
}