import React, { ChangeEvent } from 'react';

interface FileInputProps {
  onFileSelected: (file: File | undefined) => void;
}

const FileInput: React.FC<FileInputProps> = ({ onFileSelected: onFileSelected }) => {
  const handleClick = () => {
    const inputElement = document.getElementById('hiddenFileInput') as HTMLInputElement;
    inputElement.click();
  };
  const handleFileChange = (event: ChangeEvent<HTMLInputElement>) => {
    const file = event.target.files?.[0];
    onFileSelected(file? file : undefined);
  };

  return <><input type="file" id="hiddenFileInput" style={{ display: 'none' }} onChange={handleFileChange} />
         <button onClick={handleClick}>Add file</button>
         </>
};

export default FileInput;