import { DocumentAnnotationsListContext, IToolbar, IToolbarBuilder } from '@pilotdev/pilot-web-sdk';
import { Constants } from './constants';

export class DocumentAnnotationsToolbarExtensionSample extends IToolbar<DocumentAnnotationsListContext> {

  private static MENU_ITEM_NAME: string = 'miShowInfo';

  build(builder: IToolbarBuilder, context: DocumentAnnotationsListContext): void {

    const buttonHint = 'Show information';

    builder.addButtonItem(DocumentAnnotationsToolbarExtensionSample.MENU_ITEM_NAME, 0)
      .withHeader(buttonHint)
      .withIcon(Constants.BUTTON_ICON_NAME, Constants.BUTTON_ICON)
      .withHint(buttonHint);
  }

  onToolbarItemClick(name: string, context: DocumentAnnotationsListContext): void {
    if (name == DocumentAnnotationsToolbarExtensionSample.MENU_ITEM_NAME) {
      const annotationsContents = context.selectedAnnotations?.map(annotation => annotation.source?.title);
      alert('Selected annotations:\n' + annotationsContents.join('\n'));
    }
  }
}