import {
  IPageNavigation,
  IPageNavigationBuilder,
} from "@pilotdev/pilot-web-sdk";

export const VuePageAddress = "vuesample_vuepage";

export class NavigationSample implements IPageNavigation {
  build(builder: IPageNavigationBuilder): void {
    const sectionBuilder = builder
      .addSection("vue_section", 0)
      .withTitle("Vue Section");

    sectionBuilder
      .addElement(`vue_section_element`, 0)
      .withTitle("Vue Element")
      .withDescription("Redirects to Vue Openspace Page")
      .withViewId(VuePageAddress);
  }
}
