const { defineConfig } = require("@vue/cli-service");

const ModuleFederationPlugin = require("webpack/lib/container/ModuleFederationPlugin");
const CopyPlugin = require("copy-webpack-plugin");

const isProduction = process.env.NODE_ENV === "production";

module.exports = defineConfig({
  transpileDependencies: true,
  publicPath: "auto",
  outputDir: isProduction ? "./dist" : undefined,
  configureWebpack: () => {
    return {
      entry: "./src/main.ts",
      output: {
        uniqueName: "vue_extension_sample",
        scriptType: "text/javascript",
        filename: "[name].js",
        clean: true,
      },
      optimization: {
        // fix a temporary bug
        runtimeChunk: false,
        splitChunks: isProduction ? undefined : false,
      },
      plugins: [
        new ModuleFederationPlugin({
          name: "vue_extension_sample",
          library: {
            type: "var",
            name: "vue_extension_sample",
          },
          filename: "[name].js",
          exposes: [
            {
              IPageNavigation: "./src/extension/vueExtensionSample.ts",
            },
            {
              "IOpenspaceView<PageContext>":
                "./src/extension/vueExtensionSample.ts",
            },
          ],
          shared: {
            "@pilotdev/pilot-web-sdk": {
              singleton: true,
            },
          },
        }),
        new CopyPlugin({
          patterns: [
            {
              from: "./src/extension/extensions.config.json",
              to: `extensions.config.json`,
            },
          ],
        }),
      ],
      devServer: isProduction
        ? undefined
        : {
            port: 4300,
            allowedHosts: "auto",
            headers: { "Access-Control-Allow-Origin": "*" },
          },
    };
  },
});
