﻿using Autodesk.Revit.UI;
using log4net;

namespace RevitToIfcConverter.Core
{
    class ConvertToIfcExternalEvent : IExternalEventHandler
    {
        private readonly ConverterImplementation _impl;

        public ConvertToIfcExternalEvent(ConverterImplementation impl)
        {
            _impl = impl;
        }

        public void Execute(UIApplication app)
        {
            _impl.StartConverting(app);
        }

        public string GetName()
        {
            return "ConvertToIfc";
        }
    }
}
