SDK для модулей расширения к продукту CadFarmApp 
===============


Требования
----------

Для создания модулей расширения к CadFarmApp требуется один из следующих выпусков Visual Studio
- Visual Studio 2017 Professional Edition или старше

Создание и настройка проекта расширения
---------------------------------------

Чтобы создать новое расширение для CadFarmApp выполните следующие действия:

- Создайте проект типа Class Library (.NET Standard).
- Вызовите диалог настройки проекта. В поле AssemblyName добавьте к названию сборки `.extcf` Например `RengaToIfcConverter.extcf`
- Подключите к проекту nuget пакеты System.ComponentModel.Composition и Ascon.Pilot.BimConverters.Core.

Подключение SDK к проекту расширения
------------------------------------

Для подключения Ascon.Pilot.BimConverters.Core к проекту расширения можно воспользоваться встроенным в Visual Studio механизмом распространения пакетов - NuGet Packages Manager.
Для того, чтобы подключить SDK с помощью Nuget Package Manager выполните следующие шаги:
- Вызовите [Package Manager Console](https://docs.nuget.org/docs/start-here/using-the-package-manager-console);
- Выполните команду:
```cpp
Install-Package Ascon.Pilot.BimConverters.Core
```

- Щелкните правой кнопкой мыши на проекте и вызовите команду `Manage NuGet Packages`;
- Установите NuGet пакет Ascon.Pilot.BimConverters.Core для вашего проекта.


## Содержание
[Система расширений](#typesOfExtensions)
- [IConverterToIfc](#IConverterToIfc)

<a name="typesOfExtensions"/>
Система расширений
-------------------------

Система расширений основана на стандартном механизме расширений приложений в .NET - Managed Extensibility Framework (MEF). SDK содержит ряд экспортируемых и импортируемых интерфейсов. К экспортируемым интерфейсам относятся интерфейсы, которые описывают тип расширения. К импортируемым интерфейсам относятся интерфейсы взаимодействия с клиентом и работы с данными.

<a name="IConverterToIfc"/>
### Интерфейс IConverterToIfc ###

Осуществляет взаимодействие CadFarmApp с конвертером.

```cpp
string Name { get; }
```

```cpp
IEnumerable<DRule> Rules { get; }
```

```cpp
IEnumerable<ConverterSettingDescriptor> Settings { get; }
```

```cpp
bool IsConverterInstalled();
```

```cpp
void Initialize();
```

```cpp
string Convert(ConverterRequest request);
```