﻿using System;
using System.Linq;
using System.Collections.Generic;
using Ascon.Pilot.Bim.SDK.ImportSearchSetsSample.Import;
using Ascon.Pilot.Bim.SDK.ModelTab;
using Ascon.Pilot.Bim.SDK.ModelViewer;
using Ascon.Pilot.Bim.SDK.ModelTab.Toolbar;

namespace Ascon.Pilot.Bim.SDK.ImportSearchSetsSample
{
    public class ToolbarItemsController : IDisposable
    {
        private IModelTab _modelTab;
        private ImportService _importService;
        private readonly List<IToolbarButtonItem> _toolbarCommands = new List<IToolbarButtonItem>();
        private readonly byte[] _icon;

        public ToolbarItemsController(IModelTab modelTab)
        {
            _modelTab = modelTab;
            _icon = IconLoader.GetIcon("import_toolbar_icon.svg");
        }

        public void AddToolbarItems()
        {
            var toolBarManager = _modelTab.GetToolbarManager();
            var buttonItem = AddToolbarButtonItem(toolBarManager);
            _toolbarCommands.Add(buttonItem);
        }

        public IModelViewer ModelViewer { get; private set; }

        private IToolbarButtonItem AddToolbarButtonItem(IToolbarManager toolBarManager)
        {
            var buttonItem = toolBarManager.AddToolbarButtonItem(toolBarManager.GetItems().Count());
            buttonItem.Title = "Import search sets from \"Autodesk Navisworks\"";
            buttonItem.IsEnabled = false;
            buttonItem.Icon = _icon;
            buttonItem.IsTitleVisible = false;
            buttonItem.Tooltip = "Import search sets from \"Autodesk Navisworks\"";

            return buttonItem;
        }
        
        public void OnModelLoaded(IModelViewer modelViewer, ImportService importService)
        {
            if (_modelTab?.Id != modelViewer.TabId)
                return;

            _importService = importService;

            _toolbarCommands.ForEach(x => x.OnClick = () => _importService.ImportFromNavisWorks());

            ModelViewer = modelViewer;
            _toolbarCommands.ForEach(x => x.IsEnabled = true);
        }

        public void OnModelClosed(IModelViewer modelViewer)
        {
            if (_modelTab?.Id != modelViewer.TabId)
                return;

            _importService?.Dispose();

            ModelViewer = null;
            _toolbarCommands.ForEach(x => x.IsEnabled = false);
        }

        public void Dispose()
        {
            _toolbarCommands.Clear();
            _importService?.Dispose();
            _modelTab = null;
        }
    }
}
