﻿using System;
using System.Globalization;
using System.Windows.Data;
using Ascon.Pilot.Bim.SDK.ModelViewerSample.Converters.Parameters;

namespace Ascon.Pilot.Bim.SDK.ModelViewerSample.Converters
{
    public class ClipPlaneCommandParametersConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            var x = (string)values[0];
            var y = (string)values[1];
            var z = (string)values[2];
            var normalX = (string)values[3];
            var normalY = (string)values[4];
            var normalZ = (string)values[5];

            return new ClipPlaneCommandParameters(x, y, z, normalX, normalY, normalZ);
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
