﻿using System.IO;

namespace Ascon.Pilot.Bim.SDK.RengaModuleSample
{
    internal class IconLoader
    {
        public static byte[] GetIcon(string resourceName)
        {
            using (var stream = typeof(IconLoader).Assembly.GetManifestResourceStream($"Ascon.Pilot.Bim.SDK.RengaModuleSample.Resources.{resourceName}"))
            {
                return ReadBytes(stream);
            }
        }

        private static byte[] ReadBytes(Stream input)
        {
            using (var ms = new MemoryStream())
            {
                input.CopyTo(ms);
                return ms.ToArray();
            }
        }
    }
}
