﻿using System.Text.RegularExpressions;

namespace BcfApiService
{
    public static class Routes
    {
        private const string ID_PATTERN = @"[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}";
        public static readonly Regex GET_PROJECTS = new Regex(@"^\/bcf\/3\.0\/projects\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_PROJECT_BY_ID = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_TOPICS = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/topics\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_TOPIC_BY_ID = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/topics\/{ID_PATTERN}\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_COMMENTS = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/topics\/{ID_PATTERN}\/comments\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_COMMENT_BY_ID = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/topics\/{ID_PATTERN}\/comments\/{ID_PATTERN}\/?$", RegexOptions.Compiled);
        public static readonly Regex GET_VIEWPOINTS = new Regex($@"^\/bcf\/3\.0\/projects\/{ID_PATTERN}\/topics\/{ID_PATTERN}\/viewpoints\/?$", RegexOptions.Compiled);
    }
}
