﻿using Ascon.Pilot.SDK;
using BcfApiService.DTOs;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System;

namespace BcfApiService.Services
{
    public class TopicService : Service
    {
        public TopicService(IObjectsRepository objectsRepository, ISearchService searchService) : base(objectsRepository, searchService) { }

        public async Task<IEnumerable<TopicDTO>> GetTopics(Guid projectId)
        {
            var resultList = new List<TopicDTO>();
            ISearchResult searchResult = await _objectIdsLoader.Load(_modelPartType.Id);

            if (!searchResult.Result.Contains(projectId))
            {
                return resultList;
            }
            else
            {
                IDataObject modelPart = await _objectLoader.Load(projectId);
                IDataObject remarksFolder = await _objectLoader.Load(modelPart.TypesByChildren.First(x => x.Value == _remarksFolderType.Id).Key);
                IEnumerable<Guid> modelIssueIds = remarksFolder.TypesByChildren.Where(x => x.Value == _modelIssueType.Id).Select(x => x.Key);
                IEnumerable<Guid> modelRemarkIds = remarksFolder.TypesByChildren.Where(x => x.Value == _modelRemarkType.Id).Select(x => x.Key);

                foreach (Guid modelIssueId in modelIssueIds)
                {
                    IDataObject issue = await _objectLoader.Load(modelIssueId);
                    if (issue.ObjectStateInfo.State == ObjectState.Alive)
                    {
                        resultList.Add(new TopicDTO
                        {
                            Guid = issue.Id.ToString().ToUpperInvariant(),
                            CreationDate = issue.Created.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"),
                            CreationAuthor = issue.Creator.Login,
                            Title = (string)issue.Attributes["description"],
                        });
                    }
                }

                foreach (Guid modelRemarkId in modelRemarkIds)
                {
                    IDataObject remark = await _objectLoader.Load(modelRemarkId);
                    if (remark.ObjectStateInfo.State == ObjectState.Alive)
                    {
                        resultList.Add(new TopicDTO
                        {
                            Guid = remark.Id.ToString().ToUpperInvariant(),
                            CreationDate = remark.Created.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"),
                            CreationAuthor = remark.Creator.Login,
                            Title = (string)remark.Attributes["text"],
                        });
                    }
                }
                return resultList;
            }
        }

        public async Task<TopicDTO> FindTopicById(Guid projectId, Guid topicId)
        {
            ISearchResult searchResult = await _objectIdsLoader.Load(_modelPartType.Id);

            if (!searchResult.Result.Contains(projectId))
            {
                return null;
            }
            else
            {
                IDataObject modelPart = await _objectLoader.Load(projectId);
                IDataObject remarksFolder = await _objectLoader.Load(modelPart.TypesByChildren.First(x => x.Value == _remarksFolderType.Id).Key);
                IEnumerable<Guid> modelIssueIds = remarksFolder.TypesByChildren.Where(x => x.Value == _modelIssueType.Id).Select(x => x.Key);
                IEnumerable<Guid> modelRemarkIds = remarksFolder.TypesByChildren.Where(x => x.Value == _modelRemarkType.Id).Select(x => x.Key);

                if (modelIssueIds.Contains(topicId))
                {
                    IDataObject issue = await _objectLoader.Load(topicId);
                    if (issue.ObjectStateInfo.State == ObjectState.Alive)
                    {
                        return new TopicDTO
                        {
                            Guid = issue.Id.ToString().ToUpperInvariant(),
                            CreationDate = issue.Created.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"),
                            CreationAuthor = issue.Creator.Login,
                            Title = (string)issue.Attributes["description"],
                        };
                    }
                }
                else if (modelRemarkIds.Contains(topicId))
                {
                    IDataObject remark = await _objectLoader.Load(topicId);
                    if (remark.ObjectStateInfo.State == ObjectState.Alive)
                    {
                        return new TopicDTO
                        {
                            Guid = remark.Id.ToString().ToUpperInvariant(),
                            CreationDate = remark.Created.ToString("yyyy-MM-ddTHH:mm:ss.fffZ"),
                            CreationAuthor = remark.Creator.Login,
                            Title = (string)remark.Attributes["text"],
                        };
                    }
                }

                return null;
            }
        }
    }
}
