﻿using NodaTime;
using System;

namespace Ascon.Pilot.SDK.CalendarSample
{
    public class TimeZoneHandler
    {
        public static DateTime ShiftToTimeZone(DateTime localTime, string timezoneId)
        {
            if (string.IsNullOrEmpty(timezoneId))
                return localTime;

            var timezone = DateTimeZoneProviders.Tzdb.GetZoneOrNull(timezoneId);
            if (timezone == null)
                return localTime;

            var newTime = timezone.AtLeniently(LocalDateTime.FromDateTime(localTime));
            return newTime.ToDateTimeUtc().ToLocalTime();
        }

        public static DateTime ShiftFromTimeZone(DateTime localTime, string timezoneId)
        {
            if (string.IsNullOrEmpty(timezoneId))
                return localTime;

            var timezone = DateTimeZoneProviders.Tzdb.GetZoneOrNull(timezoneId);
            if (timezone == null)
                return localTime;

            var newTime = timezone.AtLeniently(LocalDateTime.FromDateTime(localTime));
            return localTime.ToUniversalTime().AddTicks(newTime.Offset.Ticks);
        }

        public static Offset? GetOffset(string timezoneId)
        {
            if (!string.IsNullOrEmpty(timezoneId))
            {
                var timezone = DateTimeZoneProviders.Tzdb.GetZoneOrNull(timezoneId);
                if (timezone != null)
                {
                    var newTime = timezone.AtLeniently(LocalDateTime.FromDateTime(DateTime.Now));
                    return newTime.Offset;
                }
            }
            return null;
        }
    }
}
