/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel;

namespace Ascon.Pilot.SDK.ChatsSample
{
    internal class MessageViewModel : INotifyPropertyChanged
    {
        private string _text;
        private DateTime _messageTime;

        public Guid MessageId { get; set; }
        public string ChatName { get; set; }
        public string Author { get; set; }
        
        public string Text
        {
            get => _text;
            set
            {
                if (_text != value)
                {
                    _text = value;
                    OnPropertyChanged(nameof(Text));
                }
            }
        }
        
        public DateTime MessageTime
        {
            get => _messageTime;
            set
            {
                if (_messageTime != value)
                {
                    _messageTime = value;
                    OnPropertyChanged(nameof(MessageTime));
                }
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged(string propertyName)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
