/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.ObjectModel;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.ChatsSample
{
    internal class MessagesViewModel : PropertyChangedBase
    {
        private ObservableCollection<MessageViewModel> _messagesCollection;

        public ObservableCollection<MessageViewModel> MessagesCollection
        {
            get => _messagesCollection;
            set
            {
                if (_messagesCollection != value)
                {
                    _messagesCollection = value;
                    NotifyOfPropertyChange(nameof(MessagesCollection));
                }
            }
        }
    }
}
