/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.ContextMenuSample
{
    [Export(typeof(IMenu<DocumentAnnotationsListContext>))]
    public class DocumentAnnotationsListContextMenuPlugin : IMenu<DocumentAnnotationsListContext>
    {
        private const string SHOW_INFO_ITEM_NAME = "miShowInfo";
        public void Build(IMenuBuilder builder, DocumentAnnotationsListContext context)
        {
            builder.AddItem(SHOW_INFO_ITEM_NAME, builder.Count).WithHeader("Показать информацию");
        }

        public void OnMenuItemClick(string name, DocumentAnnotationsListContext context)
        {
            if (name == SHOW_INFO_ITEM_NAME)
            {
                MessageBox.Show($"Выбраны замечания: {string.Join(Environment.NewLine, context.SelectedAnnotations.Select(x => x.DisplayName))}");
            }
        }
    }
}
